/*
  Copyright (c) 2010 Giuseppe Calà <jiveaxe@gmail.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/* Project related */
#include "plugin_kviewtube.h"


/* Kde related */
#include <kgenericfactory.h>
#include <khtml_part.h>
#include <kstandarddirs.h>

/* Qt related */
#include <QFile>


K_PLUGIN_FACTORY( KViewTubeFactory, registerPlugin< Plugin_KViewTube >(); )
K_EXPORT_PLUGIN( KViewTubeFactory( "kviewtube" ) )

Plugin_KViewTube::Plugin_KViewTube(QObject *parent, const QVariantList & /*args*/) :
    Plugin(parent)
{
    m_part = dynamic_cast<KHTMLPart *>(parent);

    if(!m_part)
    {
        kDebug() << "couldn't get KHTMLPart";
        return;
    }

    KParts::ReadOnlyPart *part = qobject_cast< KParts::ReadOnlyPart * >( parent );
    connect(part,SIGNAL(completed()),this,SLOT(slotApplyScript()));
    
    QFile file(KStandardDirs::locate("data", "kviewtube/plugin_kviewtube.js"));
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
	return;

    QTextStream in(&file);
    while (!in.atEnd()) {
	QString line = in.readLine();
	scriptContent += line;
    }
}

Plugin_KViewTube::~Plugin_KViewTube()
{
}

void Plugin_KViewTube::slotApplyScript()
{
    m_part->executeScript(scriptContent);
}

#include "plugin_kviewtube.moc"
